/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth;

import com.ibm.hwmca.fw.managed.HwmcaParentObject;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.ui.UIObjectProperties;
import com.ibm.hwmca.fw.ui.UIObjectsReader;
import com.ibm.hwmca.fw.ui.UIObjectsWriter;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.ShortObjectIdManager;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.config.ResourcesNodeConfigBean;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeResourceNode;
import com.ibm.hwmca.ui.bonsai.earth.StatusInfoInterface;
import com.ibm.hwmca.ui.bonsai.earth.Targetable;
import com.ibm.hwmca.ui.bonsai.earth.util.UserRolePermissionsSet;
import com.ibm.hwmca.ui.bonsai.servlet.ControllerServlet;
import com.ibm.hwmca.ui.bonsai.servlet.util.UIRefreshManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BonsaiTreeResourceMONode
extends BonsaiTreeResourceNode
implements PropertyChangeListener,
StatusInfoInterface,
Targetable {
    private static final String TRACEMASK_T = "XBUIRMNT";
    private static final String TRACEMASK_F = "XBUIRMNF";
    private static final String TRACEMASK_D = "XBUIRMND";
    private static Comparator myComparator = new MyComparator();
    private static ShortObjectIdManager idManager = UIObjectsWriter.getUIObjectsWriter().getShortObjectIdManager();
    private String shortId;
    private List moColTypes = DEFAULT_COLUMN_TYPES;
    private UserRolePermissionsSet roleSet;

    protected BonsaiTreeResourceMONode(BonsaiTreeResourceMONode clonee, BonsaiTreeNode parent) {
        super(clonee, parent);
        this.shortId = clonee.shortId;
        this.moColTypes = clonee.moColTypes;
        this.roleSet = clonee.roleSet;
    }

    public BonsaiTreeResourceMONode(ResourcesNodeConfigBean configBean, HwmcaParentObject mObj, BonsaiTreeNode parent) {
        super(configBean, parent);
        ObjectId objId = mObj.getObjectId();
        this.shortId = idManager.add(objId);
        this.roleSet = new UserRolePermissionsSet(objId);
    }

    public String getShortId() {
        return this.shortId;
    }

    public String getParentShortId() {
        BonsaiTreeNode parent = this.getParent();
        return parent instanceof Targetable ? ((Targetable)((Object)parent)).getShortId() : null;
    }

    public String getClassTypeShortId() {
        return UIObjectProperties.getClassTypeShortId(this.getMyPropertiesBuffer());
    }

    public boolean hasDefaultTask() {
        return !UIObjectProperties.isGroup(this.getMyPropertiesBuffer());
    }

    public UIInfo getUIInfo() {
        UIInfo info = super.getUIInfo();
        if (info == null) {
            byte[] buf = this.getMyPropertiesBuffer();
            info = new UIInfo(UIObjectProperties.getName(buf), UIObjectProperties.getCaption(buf), UIObjectProperties.getImageName(buf));
        }
        return info;
    }

    public boolean isPermitted(Set userRoles) {
        return this.roleSet.isPermitted(userRoles);
    }

    public LocalizableText getStatus() {
        LocalizableText status = UIObjectProperties.getStatusText(this.getMyPropertiesBuffer());
        return status == null ? new LocalizableText("none") : status;
    }

    public boolean isStatusAcceptable() {
        return UIObjectProperties.isStatusAcceptable(this.getMyPropertiesBuffer());
    }

    public boolean hasAttentions() {
        return UIObjectProperties.attentionsExist(this.getMyPropertiesBuffer());
    }

    public void setColumnTypes(List propertyKeys) {
        this.moColTypes = propertyKeys;
    }

    public List getColumnTypes() {
        return this.moColTypes;
    }

    public Map getColumnValues(Locale locale) {
        String id = this.getShortId();
        HashSet<String> idSet = new HashSet<String>(1);
        idSet.add(id);
        String[] propNames = new String[this.moColTypes.size()];
        for (int i = 0; i < propNames.length; ++i) {
            propNames[i] = (String)this.moColTypes.get(i);
        }
        UIObjectsReader reader = ControllerServlet.getUIObjectsReader();
        return (Map)reader.getProperties(idSet, propNames, locale).get(id);
    }

    public void propertyChange(PropertyChangeEvent event) {
        try {
            String propertyName = event.getPropertyName();
            Trace.trace(TRACEMASK_F, "--> BonsaiTreeResourceMONode.propertyChange(" + propertyName + ") [node_id='" + this.getId() + "']");
            if (propertyName.equals("Children")) {
                ObjectId[] objectIds = null;
                objectIds = (ObjectId[])event.getOldValue();
                if (objectIds != null) {
                    String id = null;
                    for (int i = 0; i < objectIds.length; ++i) {
                        id = idManager.getShortId(objectIds[i]);
                        Trace.trace(TRACEMASK_D, "property change for remove child with short id: " + id);
                        this.removeChildrenByShortId(id);
                    }
                    UIRefreshManager.refresh(1);
                }
                if ((objectIds = (ObjectId[])event.getNewValue()) != null) {
                    Trace.trace(TRACEMASK_D, "property change for add children - rebuilding this branch");
                    final BonsaiTreeResourceMONode thisNode = this;
                    new Thread(){

                        public void run() {
                            try {
                                BonsaiTreeManager.rebuildBranch(thisNode);
                            }
                            catch (Exception ex) {
                                Trace.trace(BonsaiTreeResourceMONode.TRACEMASK_F, "Exception: " + ex.toString());
                            }
                            UIRefreshManager.refresh(1);
                        }
                    }.start();
                }
            }
        }
        catch (Exception ex) {
            Trace.trace(TRACEMASK_F, "Exception: " + ex.toString());
        }
        Trace.trace(TRACEMASK_F, "<-- BonsaiTreeResourceMONode.propertyChange()");
    }

    protected boolean removeChildrenByShortId(String shortId) {
        HashSet<String> idsToRemove = new HashSet<String>();
        BonsaiTreeNode child = null;
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            child = (BonsaiTreeNode)i.next();
            if (!(child instanceof Targetable) || !((Targetable)((Object)child)).getShortId().equals(shortId)) continue;
            idsToRemove.add(child.getId());
        }
        int removeCount = 0;
        Iterator i2 = idsToRemove.iterator();
        while (i2.hasNext()) {
            if (!this.removeChild((String)i2.next())) continue;
            ++removeCount;
        }
        return removeCount > 0;
    }

    public BonsaiTreeNode createViewNode(BonsaiTreeNode parent) {
        BonsaiTreeResourceMONode view = new BonsaiTreeResourceMONode(this, parent);
        view.copyChildren(this);
        return view;
    }

    private byte[] getMyPropertiesBuffer() {
        return ControllerServlet.getUIObjectsReader().getBuffer(this.getShortId());
    }

    public static Comparator getComparator() {
        return myComparator;
    }

    private static class MyComparator
    implements Comparator,
    Serializable {
        public int compare(Object obj1, Object obj2) {
            BonsaiTreeResourceMONode node1 = (BonsaiTreeResourceMONode)obj1;
            BonsaiTreeResourceMONode node2 = (BonsaiTreeResourceMONode)obj2;
            int result = node1.getUIInfo().getName().compareTo(node2.getUIInfo().getName());
            if (result == 0) {
                result = node1.getId().compareTo(node2.getId());
            }
            return result;
        }

        public boolean equals(Object obj) {
            return obj instanceof MyComparator;
        }
    }
}

